<%@ Control Language="c#" AutoEventWireup="false" Codebehind="TimeTrackingDaily.ascx.cs" Inherits="Mediachase.UI.Web.TimeTracking.Modules.TimeTrackingDaily" TargetSchema="http://schemas.microsoft.com/intellisense/ie5"%>
<%@ Register TagPrefix="ibn" TagName="DateTimeControl" src="..\..\Modules\DateTimeControl.ascx" %>
<TABLE class="text" cellSpacing="0" cellPadding="0" border="0" width="100%">
	<tr>
		<td class="ibn-navline ibn-alternating" style="PADDING-RIGHT:5px; PADDING-LEFT:5px; PADDING-BOTTOM:5px; PADDING-TOP:5px">
			<%=LocRM.GetString("Date") %>
			:&nbsp;&nbsp;
			<ibn:datetimecontrol id="dtc" runat="server" ShowTime="false"></ibn:datetimecontrol>
			&nbsp;
			<asp:Button ID="btnApply" Runat="server" CssClass="text"></asp:Button>
		</td>
	</tr>
	<tr>
		<td style="PADDING-TOP: 5px" class="ibn-propertysheet" valign="top">
			<asp:DataGrid id="dgTTDaily" Runat="server" AllowPaging="False" AllowSorting="False" BorderWidth="0" CellPadding="3" CellSpacing="0" AutoGenerateColumns="False" Width="100%" gridlines="Horizontal">
				<Columns>
					<asp:BoundColumn DataField="ObjectId" ReadOnly="True" Visible="False"></asp:BoundColumn>
					<asp:BoundColumn DataField="ObjectTypeId" ReadOnly="True" Visible="False"></asp:BoundColumn>
					<asp:TemplateColumn>
						<headerstyle cssclass="ibn-vh2"></headerstyle>
						<itemstyle cssclass="ibn-vb2"></itemstyle>
						<ItemTemplate>
							<%# GetObjectTitle(
								(int)DataBinder.Eval(Container.DataItem,"ObjectId"),
								(int)DataBinder.Eval(Container.DataItem,"ObjectTypeId"),
								(string)DataBinder.Eval(Container.DataItem,"Title")
							)
							%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn>
						<headerstyle cssclass="ibn-vh2" Width="350px"></headerstyle>
						<itemstyle cssclass="ibn-vb2" Width="350px"></itemstyle>
						<ItemTemplate>
							<%# GetProjectTitle(
								(object)DataBinder.Eval(Container.DataItem,"ProjectId"),
								(object)DataBinder.Eval(Container.DataItem,"ProjectTitle")
							)
							%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn>
						<headerstyle cssclass="ibn-vh2" Width="60px"></headerstyle>
						<itemstyle cssclass="ibn-vb2" Width="60px"></itemstyle>
						<ItemTemplate>
							<%# Mediachase.UI.Web.Util.CommonHelper.GetHours((int)DataBinder.Eval(Container.DataItem,"Minutes"))	%>
						</ItemTemplate>
						<EditItemTemplate>
							<asp:TextBox Runat="server" ID="txtHours" CssClass="text" Width="30px" Text='<%# Mediachase.UI.Web.Util.CommonHelper.GetHours((int)DataBinder.Eval(Container.DataItem,"Minutes")) %>'>
							</asp:TextBox>
							<asp:RangeValidator ErrorMessage=" 0-24" Display="Dynamic" Type="Integer" MinimumValue="0" MaximumValue="24" Runat="server" CssClass="val1" ControlToValidate="txtHours" ID="Rangevalidator6"></asp:RangeValidator>
							<asp:RequiredFieldValidator ErrorMessage=" *" Display="Dynamic" ControlToValidate="txtHours" Runat="server" ID="Requiredfieldvalidator5"></asp:RequiredFieldValidator>
						</EditItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn>
						<headerstyle cssclass="ibn-vh2" Width="60px"></headerstyle>
						<itemstyle cssclass="ibn-vb2" Width="60px"></itemstyle>
						<ItemTemplate>
							<span runat=server Visible='<%# DataBinder.Eval(Container.DataItem,"IsCompleted") %>'>
							<%# DataBinder.Eval(Container.DataItem,"PercentCompleted").ToString() +" %" %></span>
						</ItemTemplate>
						<EditItemTemplate>
							<asp:DropDownList id="ddPercents" Runat=server Width=60 DataSource='<% # percents %>' DataTextField="TextField" DataValueField="ValueField" Visible='<%# DataBinder.Eval(Container.DataItem,"IsCompleted") %>' >
							</asp:DropDownList>
						</EditItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn>
						<headerstyle cssclass="ibn-vh2" Width="50"></headerstyle>
						<itemstyle cssclass="ibn-vb2" Width="50"></itemstyle>
						<itemtemplate>
							<asp:imagebutton id="ibMove" runat="server" borderwidth="0" title='<%# LocRM.GetString("Edit")%>' imageurl="../../layouts/images/Edit.gif" commandname="Edit" causesvalidation="False">
							</asp:imagebutton>
						</itemtemplate>
						<EditItemTemplate>
							<asp:imagebutton id="Imagebutton1" runat="server" borderwidth="0" title='<%# LocRM.GetString("Save")%>' imageurl="../../layouts/images/Saveitem.gif" commandname="Update" causesvalidation="True">
							</asp:imagebutton>
							&nbsp;&nbsp;
							<asp:imagebutton id="Imagebutton2" runat="server" borderwidth="0" imageurl="../../layouts/images/cancel.gif" title='<%# LocRM.GetString("Cancel")%>' commandname="Cancel" causesvalidation="False">
							</asp:imagebutton>
						</EditItemTemplate>
					</asp:TemplateColumn>
					<asp:BoundColumn DataField="ProjectId" ReadOnly="True" Visible="False"></asp:BoundColumn>
				</Columns>
			</asp:DataGrid>
		</td>
	</tr>
</TABLE>
